/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class IntMap
implements Cloneable,
Serializable {
    private transient IntMapEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private static final long serialVersionUID = 1421746759512286392L;

    public IntMap() {
        this(101, 0.75f);
    }

    public IntMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntMap(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.table = new IntMapEntry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public synchronized void clear() {
        IntMapEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public synchronized Object clone() {
        try {
            IntMap t = (IntMap)super.clone();
            t.table = new IntMapEntry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                t.table[i] = this.table[i] != null ? (IntMapEntry)this.table[i].clone() : null;
            }
            IntMap intMap = t;
            return intMap;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public synchronized boolean containsKey(int key) {
        IntMapEntry[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        IntMapEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized Enumeration elements() {
        return new IntMapEnumerator(null, this.table);
    }

    public synchronized Object get(int key) {
        IntMapEntry[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        IntMapEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Object put(int key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        IntMapEntry[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        IntMapEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(key, value);
        }
        e = new IntMapEntry();
        e.hash = hash;
        e.key = key;
        e.value = value;
        e.next = tab[index];
        tab[index] = e;
        ++this.count;
        return null;
    }

    private synchronized void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        int origlength = s.readInt();
        int elements = s.readInt();
        int length = (int)((float)elements * this.loadFactor) + elements / 20 + 3;
        if (length > elements && (length & 1) == 0) {
            --length;
        }
        if (origlength > 0 && length > origlength) {
            length = origlength;
        }
        this.table = new IntMapEntry[length];
        this.count = 0;
        while (elements > 0) {
            int key = s.readInt();
            Object value = s.readObject();
            this.put(key, value);
            --elements;
        }
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        IntMapEntry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        IntMapEntry[] newTable = new IntMapEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            IntMapEntry old = oldTable[i];
            while (old != null) {
                IntMapEntry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    public synchronized Object remove(int key) {
        IntMapEntry[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        IntMapEntry e = tab[index];
        IntMapEntry prev = null;
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public synchronized String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration e = this.elements();
        buf.append("{");
        for (int i = 0; i <= max; ++i) {
            String s2 = e.nextElement().toString();
            buf.append(s2);
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.count);
        for (int index = this.table.length - 1; index >= 0; --index) {
            IntMapEntry entry = this.table[index];
            while (entry != null) {
                s.writeInt(entry.key);
                s.writeObject(entry.value);
                entry = entry.next;
            }
        }
    }

    class IntMapEnumerator
    implements Enumeration {
        int index;
        IntMapEntry[] table;
        IntMapEntry entry;

        IntMapEnumerator(IntMap this$0, IntMapEntry[] table) {
            this.table = table;
            this.index = table.length;
        }

        public boolean hasMoreElements() {
            if (this.entry != null) {
                return true;
            }
            while (this.index-- > 0) {
                this.entry = this.table[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                IntMapEntry e = this.entry;
                this.entry = e.next;
                return e.value;
            }
            throw new NoSuchElementException("IntMapEnumerator");
        }
    }

    class IntMapEntry {
        int hash;
        int key;
        Object value;
        IntMapEntry next;

        IntMapEntry() {
        }

        protected Object clone() {
            IntMapEntry entry = new IntMapEntry();
            entry.hash = this.hash;
            entry.key = this.key;
            entry.value = this.value;
            entry.next = this.next != null ? (IntMapEntry)this.next.clone() : null;
            return entry;
        }
    }
}

